/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import lotr.common.LOTRMod;
import lotr.common.item.LOTRItemBottlePoison;
import lotr.common.item.LOTRItemGraal;
import lotr.common.item.LOTRItemMug;
import lotr.common.tileentity.LOTRTileEntityMug;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRBlockMug
extends BlockContainer {
    public static final float MUG_SCALE = 0.75f;

    public LOTRBlockMug() {
        this(3.0f, 8.0f);
    }

    public LOTRBlockMug(float f, float f1) {
        super(Material.field_151594_q);
        f /= 16.0f;
        f1 /= 16.0f;
        this.func_149676_a(0.5f - (f *= 0.75f), 0.0f, 0.5f - f, 0.5f + f, f1 *= 0.75f, 0.5f + f);
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new LOTRTileEntityMug();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        return Blocks.field_150344_f.func_149691_a(i, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconregister) {
    }

    public boolean func_149718_j(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j - 1, k);
        return block.canPlaceTorchOnTop(world, i, j - 1, k);
    }

    public boolean func_149742_c(World world, int i, int j, int k) {
        return this.func_149718_j(world, i, j, k);
    }

    public void func_149695_a(World world, int i, int j, int k, Block block) {
        if (!this.func_149718_j(world, i, j, k)) {
            int meta = world.func_72805_g(i, j, k);
            this.func_149697_b(world, i, j, k, meta, 0);
            world.func_147468_f(i, j, k);
        }
    }

    public void func_149681_a(World world, int i, int j, int k, int meta, EntityPlayer entityplayer) {
        if (entityplayer.field_71075_bZ.field_75098_d) {
            world.func_72921_c(i, j, k, meta |= 4, 4);
        }
        this.func_149697_b(world, i, j, k, meta, 0);
        super.func_149681_a(world, i, j, k, meta, entityplayer);
    }

    public ArrayList<ItemStack> getDrops(World world, int i, int j, int k, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((meta & 4) == 0) {
            ItemStack itemstack = LOTRBlockMug.getMugItem(world, i, j, k);
            LOTRTileEntityMug mug = (LOTRTileEntityMug)world.func_147438_o(i, j, k);
            if (mug != null) {
                drops.add(itemstack);
            }
        }
        return drops;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int i, int j, int k) {
        return LOTRBlockMug.getMugItem(world, i, j, k);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float f, float f1, float f2) {
        ItemStack itemstack = entityplayer.func_71045_bC();
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity != null && tileentity instanceof LOTRTileEntityMug) {
            LOTRTileEntityMug mug = (LOTRTileEntityMug)tileentity;
            ItemStack mugItem = mug.getMugItem();
            if (!mug.isEmpty() && LOTRItemMug.isItemEmptyDrink(itemstack)) {
                ItemStack takenDrink = mugItem.func_77946_l();
                LOTRItemMug.Vessel v = LOTRItemMug.getVessel(itemstack);
                LOTRItemMug.setVessel(takenDrink, v, true);
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, takenDrink);
                } else {
                    --itemstack.field_77994_a;
                    if (itemstack.field_77994_a <= 0) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, takenDrink);
                    } else if (!entityplayer.field_71071_by.func_70441_a(takenDrink)) {
                        entityplayer.func_71019_a(takenDrink, false);
                    }
                }
                mug.setEmpty();
                world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemGraal && !mug.isEmpty()) {
                int currentDrinks;
                ItemStack drinkFromMug = mugItem.func_77946_l();
                drinkFromMug.field_77994_a = 1;
                if (this.isAlcoholic(drinkFromMug) && !this.isAllowedAlcohol(drinkFromMug)) {
                    return false;
                }
                if (drinkFromMug.func_77973_b() == LOTRMod.mugWater || drinkFromMug.func_77973_b() == LOTRMod.mugMilk) {
                    return false;
                }
                NBTTagCompound tagCompound = itemstack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    itemstack.func_77982_d(tagCompound);
                }
                if ((currentDrinks = tagCompound.func_74762_e("hasDrink")) < 3) {
                    float strength = LOTRItemMug.getStrength(drinkFromMug);
                    tagCompound.func_74768_a("hasDrink", currentDrinks + 1);
                    tagCompound.func_74778_a("potion" + (currentDrinks + 1), drinkFromMug.func_77977_a());
                    tagCompound.func_74776_a("strength" + (currentDrinks + 1), strength);
                    mug.setEmpty();
                    world.func_72956_a((Entity)entityplayer, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        // empty if block
                    }
                    return true;
                }
            }
            if (mug.isEmpty() && LOTRItemMug.isItemFullDrink(itemstack)) {
                ItemStack emptyMug = LOTRItemMug.getVessel(itemstack).getEmptyVessel();
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, emptyMug);
                ItemStack mugFill = itemstack.func_77946_l();
                mugFill.field_77994_a = 1;
                mug.setMugItem(mugFill);
                world.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "lotr:item.mug_fill", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return true;
            }
            if (!mug.isEmpty()) {
                if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemBottlePoison && mug.canPoisonMug()) {
                    if (!world.field_72995_K) {
                        mug.poisonMug(entityplayer);
                        if (!entityplayer.field_71075_bZ.field_75098_d) {
                            ItemStack containerItem = itemstack.func_77973_b().getContainerItem(itemstack);
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, containerItem);
                        }
                        entityplayer.field_71070_bA.func_75142_b();
                        ((EntityPlayerMP)entityplayer).func_71120_a(entityplayer.field_71070_bA);
                    }
                    return true;
                }
                ItemStack equivalentDrink = LOTRItemMug.getEquivalentDrink(mugItem);
                Item eqItem = equivalentDrink.func_77973_b();
                boolean canDrink = false;
                if (eqItem instanceof LOTRItemMug) {
                    canDrink = ((LOTRItemMug)eqItem).canPlayerDrink(entityplayer);
                }
                if (canDrink) {
                    ItemStack mugItemResult = mugItem.func_77950_b(world, entityplayer);
                    mugItemResult = ForgeEventFactory.onItemUseFinish((EntityPlayer)entityplayer, (ItemStack)mugItem, (int)mugItem.func_77988_m(), (ItemStack)mugItemResult);
                    mug.setEmpty();
                    world.func_147471_g(i, j, k);
                    world.func_72956_a((Entity)entityplayer, "random.drink", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAllowedAlcohol(ItemStack drink) {
        return drink.func_77973_b() == LOTRMod.mugDwarvenTonic || drink.func_77973_b() == LOTRMod.mugDragonBrew || drink.func_77973_b() == LOTRMod.mugBlueDwarvenTonic || drink.func_77973_b() == LOTRMod.mugRedDwarvenTonic;
    }

    private boolean isAlcoholic(ItemStack drink) {
        return LOTRItemMug.getAlcoholicity(drink) > 0.0f;
    }

    public static ItemStack getMugItem(World world, int i, int j, int k) {
        TileEntity tileentity = world.func_147438_o(i, j, k);
        if (tileentity instanceof LOTRTileEntityMug) {
            LOTRTileEntityMug mug = (LOTRTileEntityMug)tileentity;
            return mug.getMugItem();
        }
        return new ItemStack(LOTRMod.mug);
    }

    public static void setMugItem(World world, int i, int j, int k, ItemStack itemstack, LOTRItemMug.Vessel vessel) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (te instanceof LOTRTileEntityMug) {
            LOTRTileEntityMug mug = (LOTRTileEntityMug)te;
            mug.setMugItem(itemstack);
            mug.setVessel(vessel);
        }
    }
}

